/**
 * Background service worker.
 * Only handles clear/get requests from popup (storage is written by content script directly).
 */

chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
    if (msg.action === 'get_captured') {
        chrome.storage.local.get({ capturedRequests: [] }, (data) => {
            sendResponse(data.capturedRequests);
        });
        return true;
    }

    if (msg.action === 'clear_captured') {
        chrome.storage.local.set({ capturedRequests: [] }, () => {
            sendResponse({ ok: true });
        });
        return true;
    }
});
