/**
 * Content script (ISOLATED world) — has access to chrome.storage.local.
 * Listens for postMessage from inject.js (MAIN world):
 *   - Captured API requests → stores in capturedRequests
 *   - Detected API hash → stores in apiHash
 * Also tries to extract hash from the page HTML directly.
 */
const MAX_ENTRIES = 300;

window.addEventListener('message', (event) => {
    if (!event.data) return;

    // Store captured requests
    if (event.data.source === 'tg-ads-sniffer' && event.data.entry) {
        const entry = event.data.entry;

        // Also try to extract hash from request URL
        if (entry.url) {
            const m = entry.url.match(/[?&]hash=([a-f0-9]{10,})/);
            if (m) {
                chrome.storage.local.set({ apiHash: m[1] });
            }
        }

        chrome.storage.local.get({ capturedRequests: [] }, (data) => {
            const list = data.capturedRequests;
            list.unshift(entry);
            if (list.length > MAX_ENTRIES) list.length = MAX_ENTRIES;
            chrome.storage.local.set({ capturedRequests: list });
        });
    }

    // Store detected hash
    if (event.data.source === 'tg-ads-hash' && event.data.hash) {
        chrome.storage.local.set({ apiHash: event.data.hash });
    }
});

// Also try to extract hash directly from page HTML
function extractHashFromPage() {
    const html = document.documentElement.innerHTML;
    const match = html.match(/[?&]hash=([a-f0-9]{10,})/);
    if (match) {
        chrome.storage.local.set({ apiHash: match[1] });
    }
}

if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', extractHashFromPage);
} else {
    extractHashFromPage();
}
